/*
 * Structures for recording changes to the fabric
 */

/*
 * Change state of a fabric element
 */
enum {
  FMS_UPDATE_NONE,
  FMS_UPDATE_ADD,
  FMS_UPDATE_CHANGE,
  FMS_UPDATE_REMOVE
};

/*
 * Auto-commit flags for FMS
 * changes of these types are automatically committed to the database
 * as they occur if the flag is set
 */
#define FMS_AC_NEW_HOST     0x0001		/* new host added */
#define FMS_AC_CHANGED_HOST 0x0002		/* host changed */
#define FMS_AC_NEW_LINK     0x0010		/* new link found */
#define FMS_AC_MISSING_LINK 0x0020		/* link is gone */

/*
 * Lists of all the changes from the database fabric to the currect fabric
 */
struct fms_fabric_deltas {
  struct fms_host_delta *new_hosts;
  struct fms_host_delta *changed_hosts;
  struct fms_host_delta *removed_hosts;

};

/*
 * A removed link.  Since all links have at least one end at a switch,
 * we only need to specify the switch end.
 */
struct fms_remove_link {
  struct lf_xcvr *xcvr;
  int port;

  struct fms_remove_link *next;
};

